ToggleBlockAutomaticModeEvent = {}
local ToggleBlockAutomaticModeEvent_mt = Class(ToggleBlockAutomaticModeEvent, Event)

InitEventClass(ToggleBlockAutomaticModeEvent, "ToggleBlockAutomaticModeEvent")

function ToggleBlockAutomaticModeEvent.emptyNew()
	local self = Event.new(ToggleBlockAutomaticModeEvent_mt)

	return self
end

function ToggleBlockAutomaticModeEvent.new(object, state)
	local self = ToggleBlockAutomaticModeEvent.emptyNew()
	self.object = object
	self.state = state

	return self
end

function ToggleBlockAutomaticModeEvent:readStream(streamId, connection)
	self.object = NetworkUtil.readNodeObject(streamId)
	self.state = streamReadBool(streamId)

	self:run(connection)
end

function ToggleBlockAutomaticModeEvent:writeStream(streamId, connection)
	NetworkUtil.writeNodeObject(streamId, self.object)
	streamWriteBool(streamId, self.state)
end

function ToggleBlockAutomaticModeEvent:run(connection)
	if not connection:getIsServer() then
		g_server:broadcastEvent(ToggleBlockAutomaticModeEvent.new(self.object, self.state), nil, connection, self.object)
	end
	
	if self.object ~= nil and self.object:getIsSynchronized() then
		self.object:setBlockAutomaticMode(self.state, true)
	end
end

function ToggleBlockAutomaticModeEvent.sendEvent(vehicle, state, noEventSend)
	if vehicle.spec_individualLowering ~= nil and (noEventSend == nil or noEventSend == false) then
		if g_server ~= nil then
			g_server:broadcastEvent(ToggleBlockAutomaticModeEvent.new(vehicle, state), nil, false, vehicle)
		else
			g_client:getServerConnection():sendEvent(ToggleBlockAutomaticModeEvent.new(vehicle, state))
		end
	end
end
