-- Lampovo Project ^ω^ Average Enjoyer

loadStoreCategories = {}

local modDir = g_currentModDirectory
local modName = g_currentModName

function loadStoreCategories.loadMapData(self, superFunc, xmlFile, missionInfo, baseDirectory)
    superFunc(self, xmlFile, missionInfo, baseDirectory)

    local xmlFile = XMLFile.load("ModFile", modDir .. "modDesc.xml")

    for _, key in xmlFile:iterator("modDesc.storeCategories.storeCategory") do
        g_storeManager:loadCategoryFromXML(xmlFile, key, modDir, modName)
    end

    for _, key in xmlFile:iterator("modDesc.constructionCategories.constructionCategory") do
        local categoryName = xmlFile:getString(key .. "#type")
        local defaultIconFilename = "dataS/menu/construction/ui_construction_icons.png"
        local defaultRefSize = {256, 256}
        local tabName = xmlFile:getString(key .. "#name")
        local tabTitle = g_i18n:convertText(xmlFile:getString(key .. "#title"))
        local tabIconFilename = xmlFile:getString(key .. "#iconFilename") or defaultIconFilename
        local tabRefSize = xmlFile:getVector(key .. "#refSize", defaultRefSize, 2)
        local tabIconUVs = GuiUtils.getUVs(xmlFile:getString(key .. "#iconUVs", "0 0 1 1"), tabRefSize)
        local tabIconSliceId = xmlFile:getString(key .. "#iconSliceId")

        g_storeManager:addConstructionTab(categoryName, tabName, tabTitle, tabIconFilename, tabIconUVs, "", tabIconSliceId)
    end

    xmlFile:delete()

    return true
end

StoreManager.loadMapData = Utils.overwrittenFunction(StoreManager.loadMapData, loadStoreCategories.loadMapData)