AdditionalContractChangeSettingsEvent = {};
AdditionalContractChangeSettingsEvent_mt = Class(AdditionalContractChangeSettingsEvent, Event);
InitEventClass(AdditionalContractChangeSettingsEvent, "AdditionalContractChangeSettingsEvent");

AdditionalContractChangeSettingsEvent.NUM_BITS_SETTINGS_ID = 1;
AdditionalContractChangeSettingsEvent.NUM_BITS_STATE = 2;

---Create instance of Event class
-- @return table self instance of class event
function AdditionalContractChangeSettingsEvent.emptyNew()
    local self = Event.new(AdditionalContractChangeSettingsEvent_mt);
    return self;
end;

---Create new instance of event
-- @param table object object
-- @param string, string
function AdditionalContractChangeSettingsEvent.new(settingsId, settingsState)
    local self = AdditionalContractChangeSettingsEvent.emptyNew();
    self.settingsId = settingsId;
    self.settingsState = tostring(settingsState);	
    return self;
end;

---Called on client side on join
-- @param string streamId streamId
-- @param string connection connection
function AdditionalContractChangeSettingsEvent:readStream(streamId, connection)
    self.settingsId = streamReadString(streamId, AdditionalContractChangeSettingsEvent.NUM_BITS_SETTINGS_ID);
    self.settingsState = streamReadString(streamId, AdditionalContractChangeSettingsEvent.NUM_BITS_STATE);
    self:run(connection);
end;

---Called on server side on join
-- @param string streamId streamId
-- @param string connection connection
function AdditionalContractChangeSettingsEvent:writeStream(streamId, connection)
    streamWriteString(streamId, self.settingsId, AdditionalContractChangeSettingsEvent.NUM_BITS_SETTINGS_ID);
    streamWriteString(streamId, self.settingsState, AdditionalContractChangeSettingsEvent.NUM_BITS_STATE);
end;

---Run action on receiving side
-- @param string connection connection
function AdditionalContractChangeSettingsEvent:run(connection)	
	if self.settingsId == "additionalContract_successFactor" then
		g_additionalContractTypes:setSuccessFactor(g_additionalContractUtils:getTypToString(self.settingsState));
	end;	
    if g_server ~= nil then
        g_server:broadcastEvent(self, false);
    end;
end;

