RollerChangeSettingsEvent = {};
RollerChangeSettingsEvent_mt = Class(RollerChangeSettingsEvent, Event);
InitEventClass(RollerChangeSettingsEvent, "RollerChangeSettingsEvent");

RollerChangeSettingsEvent.NUM_BITS_SETTINGS_ID = 1;
RollerChangeSettingsEvent.NUM_BITS_STATE = 2;

---Create instance of Event class
-- @return table self instance of class event
function RollerChangeSettingsEvent.emptyNew()
    local self = Event.new(RollerChangeSettingsEvent_mt);
    return self;
end;

---Create new instance of event
-- @param table object object
-- @param string, string
function RollerChangeSettingsEvent.new(settingsId, settingsState)
    local self = RollerChangeSettingsEvent.emptyNew();
    self.settingsId = settingsId;
    self.settingsState = tostring(settingsState);	
    return self;
end;

---Called on client side on join
-- @param string streamId streamId
-- @param string connection connection
function RollerChangeSettingsEvent:readStream(streamId, connection)
    self.settingsId = streamReadString(streamId, RollerChangeSettingsEvent.NUM_BITS_SETTINGS_ID);
    self.settingsState = streamReadString(streamId, RollerChangeSettingsEvent.NUM_BITS_STATE);
    self:run(connection);
end;

---Called on server side on join
-- @param string streamId streamId
-- @param string connection connection
function RollerChangeSettingsEvent:writeStream(streamId, connection)
    streamWriteString(streamId, self.settingsId, RollerChangeSettingsEvent.NUM_BITS_SETTINGS_ID);
    streamWriteString(streamId, self.settingsState, RollerChangeSettingsEvent.NUM_BITS_STATE);
end;

---Run action on receiving side
-- @param string connection connection
function RollerChangeSettingsEvent:run(connection)	
	if self.settingsId == "rollerMission_minMax" then
		g_additionalContractTypes:getTyp("rollerMission"):setMaxNumInstance(g_additionalContractUtils:getTypToString(self.settingsState));
	end;	
    if g_server ~= nil then
        g_server:broadcastEvent(self, false);
    end;
end;

