AutoRepaint = {};

AutoRepaint.metadata = {
	interface = "FS25 ...", --new LS25
	title = "AutoRepaint",
	notes = "Dieser Mod Lackiert alle Fahrzeuge um ~00:00 und 12:00 Uhr und reduziert die Kosten auf 25%. (Keine Missions Fahrzeuge)",
	author = "(by HappyLooser)",
	version = "1.0.0.1",
	build = 2,
	datum = " 20.03.2025",
	update = " 14.08.2025",
	discord = "HappyLooser Modding",
	info = "Link Freigabe,Änderungen,Kopien oder Code Benutzung ist ohne meine Zustimmung nicht erlaubt",
	"##Orginal Link Freigabe:"
};

AutoRepaint.priceFactor = 0.25; --is ~25%
AutoRepaint.minRepaint = 0.10; --from 10%,
AutoRepaint.repaintHours = {0,12,24}; --optional edit here, differenz min 1 also {0,2,4 .....}
AutoRepaint.repaintDay = false; --optional 1x pro Day (set true) --better for perfomance ! MP ?

function AutoRepaint:loadMap(mapName)
	print("---loading ".. tostring(AutoRepaint.metadata.title).. " ".. tostring(AutoRepaint.metadata.version).. "(#".. tostring(AutoRepaint.metadata.build).. ") ".. tostring(AutoRepaint.metadata.author).. "---")	
	AutoRepaint:calculateRepaintPrice();
	AutoRepaint.canRepaint = true;	
	if not AutoRepaint:isMP() or AutoRepaint:getDetiServer() or AutoRepaint:getHostServer() then
		autorepaint = {};
		function autorepaint:onHourDayChanged()
			if AutoRepaint.canRepaint and AutoRepaint:isRepaintHoursOrDay() then
				for _, vehicle in pairs(g_currentMission.vehicleSystem.vehicles) do
					if vehicle ~= nil and vehicle.finishedLoading == true and vehicle.getWearTotalAmount ~= nil and vehicle.repaintVehicle ~= nil then
						local missionsVehicle = vehicle.propertyState >= 4 or (vehicle.propertyState >= 2 and vehicle.activeMissionId ~= nil and vehicle.activeMissionId > 0);
						local isRepaint = math.min(1, 1 - vehicle:getWearTotalAmount());
						if vehicle.ownerFarmId ~= 0 and not missionsVehicle and isRepaint >= AutoRepaint.minRepaint then							
							vehicle:repaintVehicle(true);							
						end;
					end;
				end;		
				AutoRepaint.canRepaint = false;				
			end;	
			if not AutoRepaint.canRepaint and not AutoRepaint:isRepaintHoursOrDay() then
				AutoRepaint.canRepaint = true;
			end;		
		end;
		if not AutoRepaint.repaintDay then
			FSBaseMission.onHourChanged = Utils.prependedFunction(FSBaseMission.onHourChanged, autorepaint.onHourDayChanged);
		else
			FSBaseMission.onDayChanged = Utils.appendedFunction(FSBaseMission.onDayChanged, autorepaint.onHourDayChanged);
		end;
	else	
		print("---".. tostring(AutoRepaint.metadata.title).. " not loaded for MP Client---");
	end;
end;
addModEventListener(AutoRepaint);

function AutoRepaint:calculateRepaintPrice() --mod Configure Maintenance has prio
	oldWearableCalualteRepaintPrice = Wearable.calculateRepaintPrice;
	Wearable.calculateRepaintPrice = function(self, sellPrice, wearAmount)		
		local isOkay, result = pcall(oldWearableCalualteRepaintPrice, self, sellPrice, wearAmount)
		if isOkay and self ~= nil then			
			return result*AutoRepaint.priceFactor;
		end;
		return result;
	end;
end;

function AutoRepaint:getDetiServer()	
	return g_server ~= nil and g_client ~= nil and g_dedicatedServer ~= nil;	
end;

function AutoRepaint:getHostServer()		
	return g_server ~= nil and g_client ~= nil and g_dedicatedServer == nil and g_currentMission.missionDynamicInfo.isMultiplayer;	
end;

function AutoRepaint:isMP()		
	return g_currentMission.missionDynamicInfo.isMultiplayer;	
end;

function AutoRepaint:isRepaintHoursOrDay()
	if AutoRepaint.repaintDay then return true;end;
	for h=1, #AutoRepaint.repaintHours do
		if AutoRepaint.repaintHours[h] == g_currentMission.environment.currentHour then return true;end;
	end;
	return false;
end;