local OnlyUpDown = false -- true = nur Auf/Ab Wackeln //// false = Rechts/Links + Auf/Ab Wackeln
local cutter = true





local function loadInputAttacherJoint(self, superFunc, xmlFile, key, inputAttacherJoint, index)
    superFunc(self, xmlFile, key, inputAttacherJoint, index)
    local specSprayer = self.spec_sprayer
    local specMotorized = self.spec_motorized
    local specFC = self.spec_fertilizingCultivator
    local isImplement = inputAttacherJoint.jointType == AttacherJoints.JOINTTYPE_IMPLEMENT or false
    local Cutter = inputAttacherJoint.jointType == AttacherJoints.JOINTTYPE_CUTTER or inputAttacherJoint.jointType == AttacherJoints.JOINTTYPE_CUTTERHARVESTER or false




    if cutter and Cutter then
        local data = {
            weight = self:getTotalMass(true),
            limitSpringZ = 800,
            limitDampingZ = 10,
            multiplier = self:getTotalMass(true)*3}       
        data.limitSpringZ = data.limitSpringZ * data.multiplier
        data.limitDampingZ = data.limitDampingZ * data.multiplier
        inputAttacherJoint.rotLimitSpring = {0,0,data.limitSpringZ}
        inputAttacherJoint.rotLimitDamping = {0,0,data.limitDampingZ}
        return true
    end
    if isImplement then
        local isTPA = inputAttacherJoint.topReferenceNode ~= nil or false
        local haveStiffTPA = specMotorized ~= nil
        local isFertilizerSprayer =  specSprayer ~= nil and specFC == nil or false
        local data = {
            weight = self:getTotalMass(true),
            limitSpringYFront = 450,
            limitSpringYBack = 60,
            limitSpringZ = 60,
            limitDampingY = 9,
            limitDampingZ = 3,
            multiplier = self:getTotalMass(true)*15}
        data.limitSpringYBack = data.limitSpringYBack * data.multiplier
        data.limitSpringZ = data.limitSpringZ * data.multiplier
        if isFertilizerSprayer then
            data.limitSpringYBack = data.limitSpringYBack * data.multiplier * 3
            data.limitSpringZ = data.limitSpringZ * data.multiplier * 3
        end
        if OnlyUpDown then
            data.limitSpringZ = 0
        else
            if isTPA then
                if data.weight > 0.8 then
                    data.limitDampingZ = data.limitDampingZ + 8
                end
            else
                data.limitDampingZ = data.limitDampingZ + 40
            end
        end
        inputAttacherJoint.transLimitSpring = {0,data.limitSpringYBack,data.limitSpringZ}
        inputAttacherJoint.transLimitDamping = {0,data.limitDampingY,data.limitDampingZ}
        return true
    end
    return superFunc(self, xmlFile, key, inputAttacherJoint, index)
end





Attachable.loadInputAttacherJoint = Utils.overwrittenFunction(Attachable.loadInputAttacherJoint, loadInputAttacherJoint)





local function createAttachmentJoint(self, implement, noSmoothAttach)
    local specMotorized = self.spec_motorized
    local specCultivator = self.spec_cultivator
    local spec = self.spec_attacherJoints
	local jointDesc = spec.attacherJoints[implement.jointDescIndex]
    local objectAttacherJoint = implement.object.spec_attachable.attacherJoint
    local wx, wy, wz = getWorldTranslation(jointDesc.jointTransform)
	local lx, ly, lz = worldToLocal(self.components[1].node, wx, wy, wz)
    local isFrontAttacher = lz > 0 or false

    if implement.object ~= nil then
        local spec = self.spec_attacherJoints
        local jointDesc = spec.attacherJoints[implement.jointDescIndex]
        local isTPA = jointDesc.bottomArm ~= nil
        if objectAttacherJoint ~= nil and specMotorized == nil then
            if specCultivator ~= nil then
                if isTPA then
                    objectAttacherJoint.transLimitSpring[3] = 0
                    objectAttacherJoint.transLimitDamping[3] = 0
                else
                    objectAttacherJoint.transLimitSpring[2] = 0
                    objectAttacherJoint.transLimitSpring[3] = 0
                    objectAttacherJoint.transLimitDamping[2] = 0
                    objectAttacherJoint.transLimitDamping[3] = 0
                end
            end            
        end
        if isFrontAttacher then
            objectAttacherJoint.transLimitSpring[3] = 0
            objectAttacherJoint.transLimitDamping[3] = 0
        end
     end
end





AttacherJoints.createAttachmentJoint = Utils.appendedFunction(AttacherJoints.createAttachmentJoint, createAttachmentJoint)





if not OnlyUpDown then    
    local function updateAttacherJointGraphics(self, implement, dt, forceUpdate)
        if implement.object ~= nil then
            local spec = self.spec_attacherJoints
            local jointDesc = spec.attacherJoints[implement.jointDescIndex]
			if jointDesc.bottomArm ~= nil and self.spec_cultivator == nil then
                if jointDesc.bottomArm.rotationNode ~= nil and jointDesc.bottomArm.translationNode ~= nil then
					local attacherJoint = implement.object:getActiveInputAttacherJoint()
                    if jointDesc.bottomArm.rotationNode ~= jointDesc.bottomArm.translationNode then
                        if jointDesc.bottomArm.realTranslationNode == nil then
                            jointDesc.bottomArm.realTranslationNode = createTransformGroup("realTranslationNode")
                            link(jointDesc.bottomArm.rotationNode, jointDesc.bottomArm.realTranslationNode)
                            link(jointDesc.bottomArm.realTranslationNode, jointDesc.bottomArm.translationNode)
                        end
                        local x, _, _ = worldToLocal(jointDesc.bottomArm.rotationNode, getWorldTranslation(attacherJoint.node))
                        setTranslation(jointDesc.bottomArm.realTranslationNode, x, 0, 0)
                    else
                        local x, _, _ = worldToLocal(jointDesc.bottomArm.rotationNode, getWorldTranslation(attacherJoint.node))
                        setTranslation(jointDesc.bottomArm.translationNode, x, 0, 0)
                    end
                end
            end
        end
    end
    AttacherJoints.updateAttacherJointGraphics = Utils.appendedFunction(AttacherJoints.updateAttacherJointGraphics, updateAttacherJointGraphics)
end