--- Script para permitir que la IA deje marcas de neumáticos.
--- @author KCHARRO
--- @version 1.0

aiTireTracks = {}

-- Sistema de traducción
local translations = {
    activation = {
        en = "[True AI Tracks] Script loaded: AI tire tracks activated!",
        es = "[Huellas de IA] Script cargado: ¡Marcas de neumáticos para IA activadas!",
        de = "[Echte KI-Tracks] Skript geladen: KI-Reifenspuren aktiviert!"
    },
    errorAIImplement = {
        en = "[ERROR] AIImplement or getAllowTireTracks does not exist",
        es = "[ERROR] AIImplement o getAllowTireTracks no existe",
        de = "[FEHLER] AIImplement oder getAllowTireTracks existiert nicht"
    },
    errorAIJobVehicle = {
        en = "[ERROR] AIJobVehicle or getAllowTireTracks does not exist",
        es = "[ERROR] AIJobVehicle o getAllowTireTracks no existe",
        de = "[FEHLER] AIJobVehicle oder getAllowTireTracks existiert nicht"
    }
}

-- Función para obtener mensaje según idioma
local function getMessage(messageKey)
    local language = g_currentMission and g_currentMission.languageShort or "en"
    return translations[messageKey][language] or translations[messageKey]["en"]
end

--- Sobrescribe la función original para siempre permitir marcas de neumáticos.
--- @param superFunc function Función original del juego
--- @return boolean Siempre devuelve `true` para permitir deformación
function aiTireTracks:getAllowTireTracks(superFunc)
    return true -- Forzar deformación siempre
end

-- Aplicar la sobrescritura a las clases relevantes
if AIImplement ~= nil and AIImplement.getAllowTireTracks ~= nil then
    AIImplement.getAllowTireTracks = Utils.overwrittenFunction(AIImplement.getAllowTireTracks, aiTireTracks.getAllowTireTracks)
else
    print(getMessage("errorAIImplement"))
end

if AIJobVehicle ~= nil and AIJobVehicle.getAllowTireTracks ~= nil then
    AIJobVehicle.getAllowTireTracks = Utils.overwrittenFunction(AIJobVehicle.getAllowTireTracks, aiTireTracks.getAllowTireTracks)
else
    print(getMessage("errorAIJobVehicle"))
end

--- Mensaje de carga exitosa
function aiTireTracks:loadMap()
    print(getMessage("activation"))
end

-- Registrar el evento de carga
addModEventListener(aiTireTracks)