﻿----------------------------------------------------------------------------
-- ©Copyright: ViperGTS96®--------------------------------------------------
----------------------------------------------------------------------------
--------------------"The simplest design is the best design." --------------
----------------------------------------------------------------------------
----------------------------------------------------------------------------

source(Utils.getFilename("src/realDirtColor.lua", g_currentModDirectory));
source(Utils.getFilename("src/rdcInitialize.lua", g_currentModDirectory));
source(Utils.getFilename("src/rdcLoadSettings.lua", g_currentModDirectory));
source(Utils.getFilename("src/rdcSnowMelter.lua", g_currentModDirectory));

realDirtColor:Initialize();

function installSpec()
	if g_specializationManager:getSpecializationByName("realDirtColor") == nil then
		if realDirtColor == nil then 
			print("ERROR: unable to find source file 'realDirtColor.lua'");
		else 
			for typeName, typeDef in pairs(g_vehicleTypeManager.types) do
				if typeDef ~= nil and (typeName ~= "locomotive") then 
					local isWashable = false;
					local isAnimated = false;
					for name, spec in pairs(typeDef.specializationsByName) do
						if name == "washable" then 
							isWashable = true;
						elseif name == "animatedVehicle" then 
							isAnimated = true;
						end;
					end;
					if isWashable and isAnimated then
						 if typeDef.specializationsByName["realDirtColor"] == nil then
							table.insert(typeDef.specializations, realDirtColor);
							table.insert(typeDef.specializationNames, "realDirtColor");
							typeDef.specializationsByName["realDirtColor"] = realDirtColor;
						end;
					end;
				end;
			end;
		end;	
	end;
end;

TypeManager.validateTypes = Utils.appendedFunction(TypeManager.validateTypes, installSpec);